from dataclasses import dataclass, field
from .base import BasePhysicsConfig
from .env import JellyEnvConfig
from .render import PyVistaRenderConfig
from .sim import VisionSimConfig

@dataclass(kw_only=True)
class VisionPhysicsConfig(BasePhysicsConfig, name='vision'):
    # 这么写的主要作用是为了，让每个实例拥有自己的默认配置，而不是共享同一个默认配置实例
    env: JellyEnvConfig = field(default_factory=JellyEnvConfig)
    render: PyVistaRenderConfig = field(default_factory=PyVistaRenderConfig)
    sim: VisionSimConfig = field(default_factory=VisionSimConfig)
